Imports DiaryEntry, DiaryEvent


Partial Class DiaryMain
    Inherits System.Web.UI.Page
    Private eventArrayOfDays As Boolean()
    Private entryArrayOfDays As Boolean()

    Protected Sub Calendar1_SelectionChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Calendar1.SelectionChanged
        Dim DayToView, MonthToView, YearToView As String
        DayToView = Calendar1.SelectedDate.Day.ToString()
        MonthToView = Calendar1.SelectedDate.Month.ToString()
        YearToView = Calendar1.SelectedDate.Year.ToString()

        Response.Redirect("DayView.aspx?Day=" & DayToView & "&Month=" & MonthToView & "&Year=" & YearToView)

    End Sub

    Protected Sub Page_InitComplete(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.InitComplete
        eventsFromLabel.Text = Now.ToString
        eventsToLabel.Text = DateAdd(DateInterval.Day, 28, Now()).ToString

    End Sub

    Protected Sub Calendar1_OnDayRender(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.DayRenderEventArgs) Handles Calendar1.DayRender
        If Not e.Day.IsOtherMonth Then
            If entryArrayOfDays Is Nothing Then
                entryArrayOfDays = GetDaysInMonthWithEntries(Session("DiaryId"), e.Day.Date.Month, e.Day.Date.Year)
            End If

            If eventArrayOfDays Is Nothing Then
                eventArrayOfDays = GetDaysInMonthWithEvents(Session("DiaryId"), e.Day.Date.Month, e.Day.Date.Year)
            End If

            If entryArrayOfDays(CInt(e.Day.DayNumberText)) Then
                e.Cell.BackColor = Drawing.Color.Blue
            End If

            If eventArrayOfDays(CInt(e.Day.DayNumberText)) Then
                e.Cell.ForeColor = Drawing.Color.Red
            End If

        End If
    End Sub

    Protected Sub Calendar1_VisibleMonthChanged(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.MonthChangedEventArgs) Handles Calendar1.VisibleMonthChanged
        entryArrayOfDays = GetDaysInMonthWithEntries(Session("DiaryId"), Calendar1.VisibleDate.Month, Calendar1.VisibleDate.Year)
        eventArrayOfDays = GetDaysInMonthWithEvents(Session("DiaryId"), Calendar1.VisibleDate.Month, Calendar1.VisibleDate.Year)
    End Sub

End Class
